/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.client.screen.widget;

import com.mojang.math.Axis;
import it.hurts.octostudios.octolib.client.animation.Tween;
import it.hurts.octostudios.octolib.client.animation.easing.EaseType;
import it.hurts.octostudios.octolib.client.animation.easing.TransitionType;
import it.hurts.octostudios.octolib.client.screen.widget.HasRenderMatrix;
import it.hurts.octostudios.octolib.client.screen.widget.TestPin;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class TestGear
extends AbstractWidget
implements HasRenderMatrix,
ContainerEventHandler {
    private Matrix4f renderMatrix;
    Tween tween = Tween.create();
    private float rot;
    List<GuiEventListener> children = new ArrayList<GuiEventListener>();

    public TestGear(int x, int y) {
        super(x, y, 128, 128, (Component)Component.empty());
        this.children.add(new TestPin(16, 16, this));
    }

    @Override
    public Matrix4f getMatrix() {
        return this.renderMatrix;
    }

    @Override
    public void setMatrix(Matrix4f matrix) {
        this.renderMatrix = matrix;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX() + (float)this.width / 2.0f, (float)this.getY() + (float)this.height / 2.0f, 0.0f);
        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(this.rot));
        guiGraphics.pose().translate((float)(-this.width) / 2.0f - (float)this.getX(), (float)(-this.height) / 2.0f - (float)this.getY(), 0.0f);
        this.setMatrix(new Matrix4f((Matrix4fc)guiGraphics.pose().last().pose()));
        guiGraphics.renderOutline(this.getX(), this.getY(), this.width, this.height, -1);
        this.children().forEach(child -> {
            if (child instanceof Renderable) {
                Renderable renderable = (Renderable)child;
                renderable.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        });
        guiGraphics.pose().popPose();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        if (!super.mouseClicked(mouseX, mouseY, button) && result) {
            this.tween.kill();
            this.tween = Tween.create();
            this.tween.tweenMethod(this::setRot, Float.valueOf(this.rot), Float.valueOf(this.rot + 60.0f), 0.75).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUART);
            this.tween.start();
            return true;
        }
        return false;
    }

    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public boolean isDragging() {
        return false;
    }

    public void setDragging(boolean isDragging) {
    }

    @Nullable
    public GuiEventListener getFocused() {
        return null;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
    }

    public void setRot(float rot) {
        this.rot = rot;
    }
}

